CREATE TABLE "MDCALENDAR"."Calendar" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "CalendarName" varchar(512) DEFAULT NULL,
  "StartTime" datetime(6) DEFAULT NULL,
  "EndTime" datetime(6) DEFAULT NULL,
  "IsAllDay" bit DEFAULT NULL,
  "Address" varchar(512) DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "GroupID" varchar(512) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "Sequence" int DEFAULT '0',
  "IsRecur" bit DEFAULT '0',
  "Frequency" int DEFAULT '0',
  "Interval" int DEFAULT '1',
  "RecurCount" int DEFAULT '0',
  "UntilDate" datetime(6) DEFAULT NULL,
  "WeekDay" int DEFAULT NULL,
  "EventStart" datetime(6) DEFAULT NULL,
  "EventEnd" datetime(6) DEFAULT NULL,
  "CreateUser" varchar(64) DEFAULT NULL,
  "AppID" varchar(64) DEFAULT NULL,
  "IsDelete" bit DEFAULT '0',
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "Locked" bit DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL,
  "IsPrivate" bit NOT NULL DEFAULT '0',
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDCALENDAR"."Calendar_Category" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "CatID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "Color" int DEFAULT NULL,
  "CatName" varchar(400) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDCALENDAR"."Calendar_Member" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "CatID" varchar(128) DEFAULT NULL,
  "GroupID" varchar(64) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ReMark" varchar(1024) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "RemindTime" int DEFAULT NULL,
  "RemindType" int DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "VoiceRemind" bit DEFAULT '0',
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDCALENDAR"."ChildCalendarRecurTime" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" datetime(6) NOT NULL,
  "StartTime" datetime(6) NOT NULL,
  "Status" int DEFAULT NULL,
  "CalendarName" varchar(512) DEFAULT NULL,
  "EndTime" datetime(6) DEFAULT NULL,
  "IsAllDay" bit DEFAULT NULL,
  "Address" varchar(512) DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "GroupID" varchar(512) DEFAULT NULL,
  "Sequence" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "CreateUser" varchar(64) DEFAULT NULL,
  "Locked" bit DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateAccountID" varchar(64) DEFAULT NULL,
  "IsPrivate" bit NOT NULL DEFAULT '0',
  PRIMARY KEY ("AutoID")
); 

CREATE TABLE "MDCALENDAR"."ChildCalendarRecurTimeMember" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "CalendarID" varchar(64) NOT NULL,
  "UserID" varchar(64) DEFAULT NULL,
  "RecurTime" datetime(6) NOT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "GroupID" varchar(64) DEFAULT NULL,
  "CatID" varchar(64) DEFAULT NULL,
  "Types" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ReMark" varchar(1024) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "RemindTime" int DEFAULT NULL,
  "RemindType" int DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "VoiceRemind" bit DEFAULT '0',
  PRIMARY KEY ("AutoID")
); 

CREATE TABLE "MDCALENDAR"."ThirdUser" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "ThirdID" varchar(50) NOT NULL,
  "CalendarID" varchar(64) NOT NULL,
  "RecurTime" datetime(6) DEFAULT NULL,
  "CreateTime" datetime(6) NOT NULL,
  "EditTime" datetime(6) NOT NULL,
  "NickName" varchar(50) DEFAULT NULL,
  "Face" varchar(200) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE "MDCALENDAR"."User_CalCategory_Order" (
  "AutoID" int NOT NULL IDENTITY(1, 1),
  "UserID" varchar(64) DEFAULT NULL,
  "CatID" varchar(64) DEFAULT NULL,
  "DisplayOrder" int DEFAULT NULL,
  "ProjectID" varchar(64) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(64) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE UNIQUE INDEX uk_c_calendarid ON "MDCALENDAR"."Calendar"("CalendarID");
CREATE INDEX idx_c_caid ON "MDCALENDAR"."Calendar"("CreateAccountID");
CREATE INDEX idx_c_eventend ON "MDCALENDAR"."Calendar"("EventEnd");
CREATE INDEX idx_c_starttime_calendarid ON "MDCALENDAR"."Calendar"("StartTime","CalendarID");
CREATE UNIQUE INDEX uk_cc_catid ON "MDCALENDAR"."Calendar_Category"("CatID");
CREATE INDEX idx_cc_aid_catid ON "MDCALENDAR"."Calendar_Category"("AccountID","CatID");
CREATE INDEX idx_cm_calendarid ON "MDCALENDAR"."Calendar_Member"("CalendarID");
CREATE INDEX idx_cm_aid ON "MDCALENDAR"."Calendar_Member"("AccountID");
CREATE UNIQUE INDEX uk_ccr_calendarid_recur ON "MDCALENDAR"."ChildCalendarRecurTime"("CalendarID","RecurTime");
CREATE INDEX idx_ccr_starttime_endtime ON "MDCALENDAR"."ChildCalendarRecurTime"("StartTime","EndTime");
CREATE INDEX idx_ccrtm_calendarid_recurtime_aid ON "MDCALENDAR"."ChildCalendarRecurTimeMember"("CalendarID","RecurTime","AccountID");
CREATE INDEX idx_tu_calendarid ON "MDCALENDAR"."ThirdUser"("CalendarID");
CREATE INDEX idx_uco_aid_catid ON "MDCALENDAR"."User_CalCategory_Order"("AccountID","CatID");