\c mdproject

CREATE TABLE account (
  autoid serial PRIMARY KEY,
  accountid varchar(36) NOT NULL,
  mobilephone varchar(32) DEFAULT NULL,
  email varchar(128) DEFAULT NULL,
  password varchar(64) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  status int DEFAULT NULL,
  sourcetype int DEFAULT NULL
);

CREATE TABLE account_authentication (
  autoid serial PRIMARY KEY,
  sourceid varchar(128) DEFAULT NULL,
  authtype int DEFAULT NULL,
  accountid varchar(36) DEFAULT NULL,
  account varchar(128) DEFAULT NULL,
  token varchar(256) DEFAULT NULL,
  status int DEFAULT NULL,
  number int DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createaccountid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  verifycode varchar(10) DEFAULT NULL,
  lastmodifyaccountid varchar(36) DEFAULT NULL
);

CREATE TABLE account_bind_email (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  email varchar(50) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  userid varchar(36) DEFAULT NULL,
  isverify int DEFAULT NULL,
  state int DEFAULT NULL
);

CREATE TABLE account_detail (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  name varchar(128) DEFAULT NULL,
  title varchar(128) DEFAULT NULL,
  description varchar(512) DEFAULT NULL,
  startdate varchar(10) DEFAULT NULL,
  enddate varchar(10) DEFAULT NULL,
  detailtype int DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE account_friends (
  autoid serial PRIMARY KEY,
  accountida varchar(36) DEFAULT NULL,
  accountidb varchar(36) DEFAULT NULL,
  status int DEFAULT NULL,
  message varchar(100) DEFAULT NULL,
  createaccountid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE account_medal (
  autoid serial PRIMARY KEY,
  medalid varchar(36) NOT NULL,
  projectid varchar(36) DEFAULT NULL,
  issystem boolean DEFAULT NULL,
  medalname varchar(512) DEFAULT NULL,
  medaltype int DEFAULT NULL,
  sysmedaltype int DEFAULT NULL,
  description varchar(1024) DEFAULT NULL,
  isenable boolean DEFAULT NULL,
  remark varchar(1024) DEFAULT NULL,
  largepath varchar(512) DEFAULT NULL,
  middlepath varchar(512) DEFAULT NULL,
  smallpath varchar(512) DEFAULT NULL,
  createaccount varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE account_medalgrantlog (
  autoid serial PRIMARY KEY,
  grantid varchar(36) NOT NULL,
  medalid varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  fromid varchar(36) DEFAULT NULL,
  toaccountid varchar(36) DEFAULT NULL,
  remark varchar(1024) DEFAULT NULL,
  isshow boolean DEFAULT NULL,
  isget boolean DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE account_scale (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  type int DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE account_setting (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  settingname varchar(64) DEFAULT NULL,
  settingvalue varchar(512) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE accountexpand (
  autoid serial PRIMARY KEY,
  accountid varchar(36) NOT NULL,
  mark int DEFAULT NULL,
  leftmark int DEFAULT NULL,
  num_login int DEFAULT NULL,
  num_view int DEFAULT NULL,
  num_post int DEFAULT NULL,
  num_comment int DEFAULT NULL,
  lastlogintime timestamp DEFAULT NULL,
  currentlogintime timestamp DEFAULT NULL
);

CREATE TABLE accountinfo (
  autoid serial PRIMARY KEY,
  accountid varchar(36) NOT NULL,
  companyname varchar(128) DEFAULT NULL,
  profession varchar(128) DEFAULT NULL,
  avatar varchar(128) DEFAULT NULL,
  fullname varchar(128) DEFAULT NULL,
  gender int DEFAULT NULL,
  birthdate date DEFAULT NULL,
  im_qq varchar(16) DEFAULT NULL,
  sns_sina varchar(128) DEFAULT NULL,
  sns_qq varchar(128) DEFAULT NULL,
  sns_linkedin varchar(128) DEFAULT NULL,
  weixin varchar(128) DEFAULT NULL,
  appid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  firstcode varchar(2) DEFAULT NULL,
  address varchar(500) DEFAULT NULL,
  contactmobilephone varchar(32) DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE accountstatistic (
  autoid serial PRIMARY KEY,
  accountid varchar(36) NOT NULL,
  companyname varchar(128) DEFAULT NULL,
  fullname varchar(128) DEFAULT NULL,
  gender int DEFAULT NULL,
  birthdate timestamp DEFAULT NULL,
  im_qq varchar(16) DEFAULT NULL,
  mobilephone varchar(32) DEFAULT NULL,
  email varchar(128) DEFAULT NULL,
  status int DEFAULT NULL,
  sns_sina varchar(128) DEFAULT NULL,
  sns_qq varchar(128) DEFAULT NULL,
  sns_linkedin varchar(128) DEFAULT NULL,
  weixin varchar(128) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  appid varchar(36) DEFAULT NULL,
  fromregister varchar(100) DEFAULT NULL,
  num_login int DEFAULT NULL,
  num_view int DEFAULT NULL,
  num_post int DEFAULT NULL,
  num_comment int DEFAULT NULL,
  num_task int DEFAULT NULL,
  num_taskcomment int DEFAULT NULL,
  num_createcalendar int DEFAULT NULL,
  num_participatecalendar int DEFAULT NULL,
  num_file int DEFAULT NULL,
  num_image int DEFAULT NULL,
  num_voice int DEFAULT NULL,
  num_video int DEFAULT NULL,
  vipenddate timestamp DEFAULT NULL,
  lastlogintime timestamp DEFAULT NULL,
  nowmonthflow int DEFAULT NULL,
  flowresetday int DEFAULT NULL,
  storagespace int DEFAULT NULL,
  num_invite int DEFAULT NULL,
  num_project int DEFAULT NULL,
  avatar varchar(128) DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE project (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  companyname varchar(128) DEFAULT NULL,
  companynameen varchar(256) DEFAULT NULL,
  companydisplayname varchar(128) DEFAULT NULL,
  status int DEFAULT NULL,
  geographyid int DEFAULT NULL,
  industryid int DEFAULT NULL,
  balance numeric(18,4) DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  parentid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE project_department (
  autoid serial PRIMARY KEY,
  departmentid varchar(36) NOT NULL,
  departmentname varchar(128) DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  mappinggroupid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  parentid varchar(36) DEFAULT NULL,
  chargeaccountid varchar(1024) DEFAULT NULL,
  sortindex bigint NOT NULL DEFAULT 0,
  deleted boolean NOT NULL DEFAULT false,
  disabled boolean NOT NULL DEFAULT false
);

CREATE TABLE project_departmentaccount (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  departmentid varchar(36) NOT NULL,
  accountid varchar(36) NOT NULL,
  ismaindepartment boolean NOT NULL DEFAULT false,
  ismanager boolean NOT NULL DEFAULT false,
  createtime timestamp NOT NULL,
  createuser varchar(36) DEFAULT NULL,
  updatetime timestamp NOT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  deleted boolean NOT NULL DEFAULT false,
  displayorder int NOT NULL DEFAULT 0
);

CREATE TABLE project_jobaccount (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  jobid varchar(36) NOT NULL,
  accountid varchar(36) NOT NULL,
  createuser varchar(36) DEFAULT NULL,
  createtime timestamp NOT NULL,
  updatetime timestamp NOT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  departmentid varchar(36) DEFAULT NULL
);

CREATE TABLE project_finance (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  address varchar(256) DEFAULT NULL,
  recipientname varchar(64) DEFAULT NULL,
  postcode varchar(16) DEFAULT NULL,
  mobilephone varchar(32) DEFAULT NULL,
  contactphone varchar(32) DEFAULT NULL,
  fax varchar(32) DEFAULT NULL,
  email varchar(128) DEFAULT NULL,
  emailrecipientname varchar(64) DEFAULT NULL,
  invoicetype int DEFAULT NULL,
  taxnumber varchar(64) DEFAULT NULL,
  taxbank varchar(128) DEFAULT NULL,
  taxbanknumber varchar(64) DEFAULT NULL,
  taxregaddress varchar(256) DEFAULT NULL,
  taxregcontactphone varchar(32) DEFAULT NULL,
  isgeneraltaxpayer boolean DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE project_job (
  autoid serial PRIMARY KEY,
  jobid varchar(36) NOT NULL,
  jobname varchar(128) DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE project_setting (
  autoid serial PRIMARY KEY,
  projectid varchar(36) DEFAULT NULL,
  settingname varchar(64) DEFAULT NULL,
  settingvalue varchar(255) DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE project_source (
  autoid serial PRIMARY KEY,
  source int DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE project_worksite (
  autoid serial PRIMARY KEY,
  worksiteid varchar(36) NOT NULL,
  worksitename varchar(128) DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE projectauthorization (
  autoid serial PRIMARY KEY,
  projectid varchar(36) DEFAULT NULL,
  appkey varchar(100) DEFAULT NULL,
  secretkey varchar(100) DEFAULT NULL,
  expiretime timestamp DEFAULT NULL,
  type int DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  createaccountid varchar(36) DEFAULT NULL,
  status int DEFAULT NULL,
  sign varchar(512) DEFAULT NULL
);

CREATE TABLE routingaccount (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  userid varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  status int DEFAULT NULL,
  serverid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  companyname varchar(128) DEFAULT NULL,
  usertype int DEFAULT NULL
);

CREATE TABLE routingproject (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  parentid varchar(36) DEFAULT NULL,
  serverid varchar(36) DEFAULT NULL,
  companyname varchar(128) DEFAULT NULL,
  subdomain varchar(64) DEFAULT NULL,
  baseauthenticationdomain varchar(128) DEFAULT NULL,
  expandauthenticationdomain varchar(512) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE routingprojectexpand (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  companyname varchar(128) DEFAULT NULL,
  isemail boolean DEFAULT NULL,
  paidtype int DEFAULT NULL,
  geography int DEFAULT NULL,
  industry int DEFAULT NULL,
  num_user int DEFAULT NULL,
  num_group int DEFAULT NULL,
  num_post int DEFAULT NULL,
  num_comment int DEFAULT NULL,
  num_pic int DEFAULT NULL,
  num_doc int DEFAULT NULL,
  num_qa int DEFAULT NULL,
  num_task int DEFAULT NULL,
  num_sms int DEFAULT NULL,
  filesize_pic numeric(20,3) DEFAULT NULL,
  filesize_doc numeric(20,3) DEFAULT NULL,
  logincountbylastweek int DEFAULT NULL,
  postcountbylastweek int DEFAULT NULL,
  commentcountbylastweek int DEFAULT NULL,
  lastlogintime timestamp DEFAULT NULL,
  invoicetype int DEFAULT NULL,
  createuser varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  vitality numeric(18,0) DEFAULT NULL,
  num_calander int DEFAULT NULL,
  num_voice int DEFAULT NULL,
  num_video int DEFAULT NULL,
  num_taskreply int DEFAULT NULL,
  num_login int DEFAULT NULL
);

CREATE TABLE routingprojectexpandforother (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  balance numeric(10,2) DEFAULT NULL,
  paystatus int DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE routinguserexpand (
  autoid serial PRIMARY KEY,
  userid varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  companyname varchar(128) DEFAULT NULL,
  num_projectusers int DEFAULT NULL,
  email varchar(128) DEFAULT NULL,
  status int DEFAULT NULL,
  isadmin int DEFAULT NULL,
  usertype int DEFAULT NULL,
  fullname varchar(128) DEFAULT NULL,
  mark int DEFAULT NULL,
  lastmark int DEFAULT NULL,
  grade varchar(64) DEFAULT NULL,
  avatar varchar(128) DEFAULT NULL,
  gender int DEFAULT NULL,
  birthdate date DEFAULT NULL,
  job varchar(64) DEFAULT NULL,
  department varchar(64) DEFAULT NULL,
  city varchar(64) DEFAULT NULL,
  mobilephone varchar(32) DEFAULT NULL,
  contactphone varchar(32) DEFAULT NULL,
  num_login int DEFAULT NULL,
  num_view int DEFAULT NULL,
  num_follower int DEFAULT NULL,
  num_concern int DEFAULT NULL,
  num_post int DEFAULT NULL,
  num_comment int DEFAULT NULL,
  lastlogintime timestamp DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  accountid varchar(36) DEFAULT NULL,
  departmentid varchar(36) DEFAULT NULL,
  jobid varchar(36) DEFAULT NULL
);

CREATE TABLE fixeddata (
  autoid serial PRIMARY KEY,
  dataid int DEFAULT NULL,
  dataname varchar(128) DEFAULT NULL,
  parentdataid int DEFAULT NULL,
  datatype int DEFAULT NULL
);

CREATE TABLE importuserinfo (
  autoid serial PRIMARY KEY,
  projectid varchar(36) DEFAULT NULL,
  status int DEFAULT NULL,
  fullname varchar(100) DEFAULT NULL,
  account varchar(100) DEFAULT NULL,
  department varchar(100) DEFAULT NULL,
  job varchar(100) DEFAULT NULL,
  companyname varchar(100) DEFAULT NULL,
  worksite varchar(100) DEFAULT NULL,
  jobnumber varchar(100) DEFAULT NULL,
  contactphone varchar(100) DEFAULT NULL,
  createaccountid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  departmentid varchar(36) DEFAULT NULL,
  accountid varchar(36) DEFAULT NULL,
  worksiteid varchar(36) DEFAULT NULL,
  jobid varchar(36) DEFAULT NULL,
  departmentids varchar(1000) DEFAULT NULL,
  jobids varchar(1000) DEFAULT NULL,
  orgroleids varchar(1000) DEFAULT NULL,
  usemultijobs boolean DEFAULT false NOT NULL,
  departmentjobidmaps varchar(2000) DEFAULT NULL
);

CREATE TABLE linkauthentication (
  autoid serial PRIMARY KEY,
  sourceid varchar(128) DEFAULT NULL,
  invitefromtype int DEFAULT NULL,
  token varchar(255) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createaccountid varchar(36) DEFAULT NULL,
  linkfromtype int DEFAULT NULL,
  deadtime timestamp DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL
);

CREATE TABLE userscard (
  autoid serial PRIMARY KEY,
  userid varchar(36) NOT NULL,
  accountid varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  companyname varchar(128) DEFAULT NULL,
  fullname varchar(128) DEFAULT NULL,
  job varchar(64) DEFAULT NULL,
  department varchar(128) DEFAULT NULL,
  contactphone varchar(32) DEFAULT NULL,
  worksite varchar(128) DEFAULT NULL,
  jobnumber varchar(128) DEFAULT NULL,
  status int DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  departmentid varchar(36) DEFAULT NULL,
  worksiteid varchar(36) DEFAULT NULL,
  jobid varchar(36) DEFAULT NULL,
  usemultijobs boolean DEFAULT false NOT NULL
);

CREATE TABLE role (
  autoid serial PRIMARY KEY,
  projectid varchar(50) DEFAULT NULL,
  roleid varchar(50) DEFAULT NULL,
  rolename varchar(50) DEFAULT NULL,
  createuser varchar(50) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  lastmodifyuser varchar(50) DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  isdelete boolean DEFAULT NULL,
  entityid varchar(50) DEFAULT NULL,
  entitytype int DEFAULT NULL,
  roletype int DEFAULT NULL
);

CREATE TABLE rolepermission (
  autoid serial PRIMARY KEY,
  projectid varchar(50) DEFAULT NULL,
  roleid varchar(50) DEFAULT NULL,
  permissionid int DEFAULT NULL,
  createuser varchar(50) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  lastmodifyuser varchar(50) DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  entityid varchar(50) DEFAULT NULL,
  entitytype int DEFAULT NULL
);

CREATE TABLE permission (
  autoid serial PRIMARY KEY,
  typeid int DEFAULT NULL,
  typename varchar(100) DEFAULT NULL,
  permissionid int DEFAULT NULL,
  permissionname varchar(100) DEFAULT NULL,
  istypeadmin boolean DEFAULT NULL,
  description varchar(200) DEFAULT NULL,
  parentid int DEFAULT NULL,
  orderid int DEFAULT NULL,
  entitytype int DEFAULT NULL,
  haschild boolean DEFAULT NULL
);

CREATE TABLE userrole (
  autoid serial PRIMARY KEY,
  accountid varchar(50) DEFAULT NULL,
  projectid varchar(50) DEFAULT NULL,
  roleid varchar(50) DEFAULT NULL,
  status int DEFAULT NULL,
  createuser varchar(50) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  lastmodifyuser varchar(50) DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  userscopetype int DEFAULT NULL,
  entityid varchar(50) DEFAULT NULL,
  entitytype int DEFAULT NULL,
  originid varchar(50) DEFAULT NULL,
  originname varchar(50) DEFAULT NULL,
  origintype int DEFAULT NULL
);

CREATE TABLE project_userrule (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  ruleid varchar(36) NOT NULL,
  createtime timestamp NOT NULL,
  createuser varchar(36) NOT NULL,
  updatetime timestamp NOT NULL,
  lastmodifyuser varchar(36) NOT NULL,
  ruletype int NOT NULL DEFAULT '10'
);

CREATE TABLE project_userruleitem (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  ruleid varchar(36) NOT NULL,
  ruleitemtype int NOT NULL DEFAULT '0',
  targetid varchar(50) NOT NULL,
  targettype int NOT NULL DEFAULT '0',
  createtime timestamp NOT NULL,
  createuser varchar(36) NOT NULL
);

CREATE TABLE project_organize (
  autoid serial PRIMARY KEY,
  organizeid varchar(36) NOT NULL,
  organizegroupid varchar(36) DEFAULT NULL,
  organizename varchar(128) DEFAULT NULL,
  projectid varchar(36) NOT NULL,
  remark text,
  sortindex int NOT NULL,
  createuser varchar(36) DEFAULT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  disabled boolean NOT NULL DEFAULT false
);

CREATE TABLE project_organizeaccount (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  organizeid varchar(36) NOT NULL,
  accountid varchar(36) NOT NULL,
  createuser varchar(36) DEFAULT NULL,
  createtime timestamp NOT NULL,
  updatetime timestamp NOT NULL,
  lastmodifyuser varchar(36) DEFAULT NULL
);

CREATE TABLE project_orgrolechargedepartment (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  orgroleid varchar(36) NOT NULL,
  accountid varchar(36) NOT NULL,
  departmentid varchar(36) NOT NULL,
  isincludesub boolean NOT NULL DEFAULT true,
  createuser varchar(36) NOT NULL,
  createtime timestamp NOT NULL,
  updatetime timestamp NOT NULL,
  lastmodifyuser varchar(36) NOT NULL
);

CREATE TABLE project_orgrolegroup (
  autoid serial PRIMARY KEY,
  projectid varchar(36) NOT NULL,
  organizegroupid varchar(36) NOT NULL,
  organizegroupname varchar(128),
  sortindex int DEFAULT 0 NOT NULL,
  createuser varchar(36) NOT NULL,
  lastmodifyuser varchar(36) NOT NULL,
  createtime timestamp NOT NULL,
  updatetime timestamp NOT NULL,
  disabled boolean NOT NULL DEFAULT false
);

CREATE INDEX idx_account_aid ON account USING btree (accountid);
CREATE INDEX idx_amedal_mid ON account_medal USING btree (medalid);
CREATE INDEX idx_amedal_gid ON account_medalgrantlog USING btree (grantid);
CREATE INDEX idx_aexpand_aid ON accountexpand USING btree (accountid);
CREATE INDEX idx_ainfo_aid ON accountinfo USING btree (accountid);
CREATE INDEX idx_astatistic_aid ON accountstatistic USING btree (accountid);
CREATE INDEX idx_project_pid ON project USING btree (projectid);
CREATE INDEX idx_pdept_pid_paid ON project_department USING btree (projectid, parentid);
CREATE INDEX idx_pdept_did_pid ON project_department USING btree (departmentid, projectid);
CREATE INDEX idx_pda_pid_did_aid ON project_departmentaccount USING btree (projectid, departmentid, accountid);
CREATE INDEX idx_pda_pid_aid ON project_departmentaccount USING btree (projectid, accountid);
CREATE INDEX idx_pda_pid_did_ord ON project_departmentaccount USING btree (projectid, departmentid, displayorder);
CREATE INDEX idx_pja_pid_jid_aid ON project_jobaccount USING btree (projectid, jobid, accountid);
CREATE INDEX idx_pja_pid_aid ON project_jobaccount USING btree (projectid, accountid);
CREATE INDEX idx_pf_pid ON project_finance USING btree (projectid);
CREATE INDEX idx_pj_pid_jid ON project_job USING btree (projectid, jobid);
CREATE INDEX idx_pj_jid ON project_job USING btree (jobid);
CREATE INDEX idx_pw_pid_wid ON project_worksite USING btree (projectid, worksiteid);
CREATE INDEX idx_pw_wid ON project_worksite USING btree (worksiteid);
CREATE UNIQUE INDEX uidx_ra_pid_aid ON routingaccount USING btree (projectid, accountid);
CREATE INDEX idx_ra_aid_pid ON routingaccount USING btree (accountid, projectid);
CREATE INDEX idx_rp_pid ON routingproject USING btree (projectid);
CREATE INDEX idx_rpe_pid ON routingprojectexpand USING btree (projectid);
CREATE INDEX idx_rpefo_pid ON routingprojectexpandforother USING btree (projectid);
CREATE UNIQUE INDEX uidx_ucard_pid_aid ON userscard USING btree (projectid, accountid);
CREATE INDEX idx_ucard_aid_pid ON userscard USING btree (accountid, projectid);
CREATE INDEX idx_role_pid_rid ON role USING btree (projectid, roleid);
CREATE INDEX idx_role_rid_eid_etype ON role USING btree (roleid, entityid, entitytype);
CREATE INDEX idx_rp_pid_pmsid ON rolepermission USING btree (projectid, permissionid);
CREATE INDEX idx_rp_pid_rid ON rolepermission USING btree (projectid, roleid);
CREATE INDEX idx_rp_pid_eid_etype ON rolepermission USING btree (permissionid, entityid, entitytype);
CREATE INDEX idx_rp_rid_eid_etype ON rolepermission USING btree (roleid, entityid, entitytype);
CREATE INDEX idx_perm_pid_etype ON permission USING btree (permissionid, entitytype);
CREATE INDEX idx_ur_aid_pid ON userrole USING btree (accountid, projectid);
CREATE INDEX idx_ur_pid_rid ON userrole USING btree (projectid, roleid);
CREATE INDEX idx_ur_etype_eid_aid ON userrole USING btree (entitytype, entityid, accountid);
CREATE INDEX idx_ur_etype_eid_rid ON userrole USING btree (entitytype, entityid, roleid);
CREATE INDEX idx_pur_pid ON project_userrule USING btree (projectid);
CREATE INDEX idx_pur_rid ON project_userrule USING btree (ruleid);
CREATE INDEX idx_puri_pid_rid ON project_userruleitem USING btree (projectid, ruleid);
CREATE INDEX idx_po_pid_oid ON project_organize USING btree (projectid, organizeid);
CREATE INDEX idx_poa_pid_oid_aid ON project_organizeaccount USING btree (projectid, organizeid, accountid);
CREATE INDEX idx_porcd_pid_orid_aid ON project_orgrolechargedepartment USING btree (projectid, orgroleid, accountid);
CREATE INDEX idx_porg_pid ON project_orgrolegroup USING btree (projectid);