CREATE TABLE account_device (
  autoid serial PRIMARY KEY,
  accountid varchar(64) DEFAULT NULL,
  appid varchar(64) DEFAULT NULL,
  device varchar(256) DEFAULT NULL,
  devicetype int DEFAULT '0',
  regid varchar(256) DEFAULT NULL,
  notifytype int DEFAULT NULL,
  ostype varchar(128) DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  language varchar(50) DEFAULT NULL,
  appversion varchar(30) DEFAULT NULL,
  source int DEFAULT NULL,
  channel int DEFAULT NULL
);

CREATE TABLE application (
  autoid serial PRIMARY KEY,
  appid varchar(64) NOT NULL,
  appname varchar(256) DEFAULT NULL,
  avatar varchar(128) DEFAULT NULL,
  summary varchar(256) DEFAULT NULL,
  about varchar(1024) DEFAULT NULL,
  is_personal boolean DEFAULT NULL,
  is_free boolean DEFAULT NULL,
  is_private boolean DEFAULT false,
  projectidrange varchar(1024) DEFAULT NULL,
  showmodel int NOT NULL DEFAULT '0',
  pricing_fee numeric(10,2) DEFAULT '0.00',
  pricing_unit int DEFAULT '0',
  pricing_time int DEFAULT '0',
  pricing_type int DEFAULT '3',
  pricing_mark varchar(1024) DEFAULT NULL,
  noticeurl varchar(256) DEFAULT NULL,
  appurl varchar(128) DEFAULT NULL,
  homeurl varchar(128) DEFAULT NULL,
  settingurl varchar(128) DEFAULT NULL,
  consumer_key varchar(128) DEFAULT NULL,
  consumer_secret varchar(128) DEFAULT NULL,
  authorize_sign int DEFAULT '0',
  authorize_lic int DEFAULT '0',
  calback_url varchar(128) DEFAULT NULL,
  rating numeric(8,2) DEFAULT NULL,
  num_user int DEFAULT NULL,
  num_post int DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  createuser varchar(64) DEFAULT NULL,
  lastmodifyuser varchar(64) DEFAULT NULL,
  status int DEFAULT NULL,
  type int DEFAULT NULL,
  remark varchar(512) DEFAULT NULL,
  categoryid varchar(64) DEFAULT NULL,
  geoid int NOT NULL DEFAULT '1',
  devicefield varchar(512) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  publictime timestamp DEFAULT NULL,
  applystatus int DEFAULT NULL,
  is_wap boolean DEFAULT true,
  subscibeurl varchar(256) DEFAULT NULL,
  appcode varchar(1024) DEFAULT NULL,
  appmdconnect varchar(1024) DEFAULT NULL,
  appcompanyname varchar(1024) DEFAULT NULL,
  appcontact varchar(1024) DEFAULT NULL,
  urlscheme varchar(1024) DEFAULT NULL,
  androidsso boolean DEFAULT NULL,
  iossso boolean DEFAULT NULL,
  appemail varchar(1024) DEFAULT NULL,
  h5url varchar(1024) DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL,
  webhookurl varchar(500) DEFAULT NULL,
  modules varchar(100) DEFAULT NULL,
  webhookcode varchar(20) DEFAULT NULL,
  webhookstatus int DEFAULT '1'
);

CREATE TABLE application_admin (
  autoid serial PRIMARY KEY,
  appid varchar(64) NOT NULL,
  userid varchar(64) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  createuser varchar(64) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL,
  createaccountid varchar(64) DEFAULT NULL
);

CREATE TABLE oauth2_access_token (
  autoid serial PRIMARY KEY,
  accesstoken varchar(128) NOT NULL,
  accountid varchar(128) NOT NULL,
  appid varchar(128) NOT NULL,
  projectid varchar(128) DEFAULT NULL,
  accesstokenexpires timestamp DEFAULT NULL,
  refreshtoken varchar(128) DEFAULT NULL,
  refreshtokenexpires timestamp DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE project_application (
  autoid serial PRIMARY KEY,
  projectid varchar(64) DEFAULT NULL,
  appid varchar(64) DEFAULT NULL,
  appcustomname varchar(128) DEFAULT NULL,
  groupid varchar(1024) DEFAULT NULL,
  rating int DEFAULT NULL,
  status int DEFAULT NULL,
  createtime timestamp DEFAULT NOW(),
  updatetime timestamp DEFAULT NOW()
);

CREATE TABLE user_application (
  autoid serial PRIMARY KEY,
  userid varchar(64) DEFAULT NULL,
  appid varchar(64) DEFAULT NULL,
  devicemark varchar(128) DEFAULT NULL,
  rating int DEFAULT NULL,
  status int DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  devicetype int NOT NULL DEFAULT '0',
  regid varchar(128) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL
);

CREATE TABLE user_application_order (
  autoid serial PRIMARY KEY,
  userid varchar(64) NOT NULL,
  appid varchar(64) NOT NULL,
  displayorder int NOT NULL,
  createtime timestamp NOT NULL,
  istop boolean DEFAULT NULL,
  toporder int DEFAULT NULL,
  accountid varchar(64) DEFAULT NULL,
  projectid varchar(64) DEFAULT NULL
);

CREATE INDEX idx_device ON account_device USING btree (device);
CREATE UNIQUE INDEX uk_app_appid ON application USING btree (appid);
CREATE INDEX idx_app_ck ON application USING btree (consumer_key);
CREATE INDEX idx_app_admin_pid_appid ON application_admin USING btree (projectid, appid);
CREATE INDEX idx_oat_at ON oauth2_access_token USING btree (accesstoken);
CREATE INDEX idx_oat_rt ON oauth2_access_token USING btree (refreshtoken);
CREATE INDEX idx_oat_aid_appid ON oauth2_access_token USING btree (accountid, appid);
CREATE INDEX idx_app_pid_appid ON project_application USING btree (projectid, appid);
CREATE INDEX idx_user_app_aid_appid ON user_application USING btree (accountid, appid);
CREATE INDEX idx_user_app_order_aid ON user_application_order USING btree (accountid);