CREATE TABLE account_actionlog (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  title varchar(255) DEFAULT NULL,
  description varchar(512) DEFAULT NULL,
  type int DEFAULT NULL,
  ip varchar(32) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE account_costlog (
  autoid serial PRIMARY KEY,
  accountid varchar(36) DEFAULT NULL,
  title varchar(255) DEFAULT NULL,
  costmark int DEFAULT NULL,
  leftmark int DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE project_costlog (
  autoid serial PRIMARY KEY,
  projectid varchar(36) DEFAULT NULL,
  type int DEFAULT NULL,
  title varchar(255) DEFAULT NULL,
  costmark numeric(18,4) DEFAULT NULL,
  leftmark numeric(18,4) DEFAULT NULL,
  createaccount varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE project_costoperatelog (
  autoid serial PRIMARY KEY,
  recordid varchar(36) DEFAULT NULL,
  orderid varchar(36) DEFAULT NULL,
  price numeric(18,4) DEFAULT NULL,
  operatetype int DEFAULT NULL,
  remark text,
  createaccount varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL
);

CREATE TABLE project_transactionrecord (
  autoid serial PRIMARY KEY,
  recordid varchar(36) DEFAULT NULL,
  orderid varchar(36) DEFAULT NULL,
  appid varchar(36) DEFAULT NULL,
  recordtype int DEFAULT NULL,
  status int DEFAULT NULL,
  price numeric(18,4) DEFAULT NULL,
  remark text,
  createaccount varchar(36) DEFAULT NULL,
  payaccount varchar(36) DEFAULT NULL,
  projectid varchar(36) DEFAULT NULL,
  createtime timestamp DEFAULT NULL,
  customoverduetime timestamp DEFAULT NULL,
  updatetime timestamp DEFAULT NULL,
  recordtypetitle varchar(128) DEFAULT NULL,
  extendid varchar(128) DEFAULT NULL
);