USE MDProject;

CREATE TABLE Account(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(36) NOT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Password" varchar(64) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "SourceType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_Authentication(
  "AutoId" int IDENTITY(1, 1),
  "SourceId" varchar(128) DEFAULT NULL,
  "AuthType" int DEFAULT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "Account" varchar(128) DEFAULT NULL,
  "Token" varchar(256) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Number" int DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "VerifyCode" varchar(10) DEFAULT NULL,
  "LastModifyAccountId" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_Bind_Email(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "Email" varchar(50) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UserId" varchar(36) DEFAULT NULL,
  "IsVerify" int DEFAULT NULL,
  "State" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_Detail(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "Name" varchar(128) DEFAULT NULL,
  "Title" varchar(128) DEFAULT NULL,
  "Description" varchar(512) DEFAULT NULL,
  "StartDate" varchar(10) DEFAULT NULL,
  "EndDate" varchar(10) DEFAULT NULL,
  "DetailType" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_Friends(
  "AutoId" int IDENTITY(1, 1),
  "AccountIdA" varchar(36) DEFAULT NULL,
  "AccountIdB" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Message" varchar(100) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_Medal(
  "AutoId" int IDENTITY(1, 1),
  "MedalId" varchar(36) NOT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "IsSystem" boolean DEFAULT NULL,
  "MedalName" varchar(512) DEFAULT NULL,
  "MedalType" int DEFAULT NULL,
  "SysMedalType" int DEFAULT NULL,
  "Description" varchar(1024) DEFAULT NULL,
  "IsEnable" boolean DEFAULT NULL,
  "Remark" varchar(1024) DEFAULT NULL,
  "LargePath" varchar(512) DEFAULT NULL,
  "MiddlePath" varchar(512) DEFAULT NULL,
  "SmallPath" varchar(512) DEFAULT NULL,
  "CreateAccount" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_MedalGrantLog(
  "AutoId" int IDENTITY(1, 1),
  "GrantId" varchar(36) NOT NULL,
  "MedalId" varchar(36) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "FromId" varchar(36) DEFAULT NULL,
  "ToAccountId" varchar(36) DEFAULT NULL,
  "Remark" varchar(1024) DEFAULT NULL,
  "IsShow" boolean DEFAULT NULL,
  "IsGet" boolean DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Account_Scale(
  "AutoID" int IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Account_Setting(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "SettingName" varchar(64) DEFAULT NULL,
  "SettingValue" varchar(512) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE AccountExpand(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(36) NOT NULL,
  "Mark" int DEFAULT NULL,
  "LeftMark" int DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "CurrentLoginTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE AccountInfo(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Profession" varchar(128) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" date DEFAULT NULL,
  "IM_QQ" varchar(16) DEFAULT NULL,
  "SNS_Sina" varchar(128) DEFAULT NULL,
  "SNS_QQ" varchar(128) DEFAULT NULL,
  "SNS_Linkedin" varchar(128) DEFAULT NULL,
  "WeiXin" varchar(128) DEFAULT NULL,
  "AppId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "FirstCode" varchar(2) DEFAULT NULL,
  "Address" varchar(500) DEFAULT NULL,
  "ContactMobilePhone" varchar(32) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE AccountStatistic(
  "AutoId" int IDENTITY(1, 1),
  "AccountID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" datetime(6) DEFAULT NULL,
  "IM_QQ" varchar(16) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "SNS_Sina" varchar(128) DEFAULT NULL,
  "SNS_QQ" varchar(128) DEFAULT NULL,
  "SNS_Linkedin" varchar(128) DEFAULT NULL,
  "WeiXin" varchar(128) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "AppId" varchar(36) DEFAULT NULL,
  "FromRegister" varchar(100) DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "Num_Task" int DEFAULT NULL,
  "Num_TaskComment" int DEFAULT NULL,
  "Num_CreateCalendar" int DEFAULT NULL,
  "Num_ParticipateCalendar" int DEFAULT NULL,
  "Num_File" int DEFAULT NULL,
  "Num_Image" int DEFAULT NULL,
  "Num_Voice" int DEFAULT NULL,
  "Num_Video" int DEFAULT NULL,
  "VIPEndDate" datetime(6) DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "NowMonthFlow" int DEFAULT NULL,
  "FlowResetDay" int DEFAULT NULL,
  "StorageSpace" int DEFAULT NULL,
  "Num_Invite" int DEFAULT NULL,
  "Num_Project" int DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project(
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "CompanyNameEn" varchar(256) DEFAULT NULL,
  "CompanyDisplayName" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "GeographyID" int DEFAULT NULL,
  "IndustryID" int DEFAULT NULL,
  "Balance" decimal(18,4) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ParentID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_Department
(
    "AutoID"          int IDENTITY(1, 1),
    "DepartmentID"    varchar(36) NOT NULL,
    "DepartmentName"  varchar(128)      DEFAULT NULL,
    "CreateUser"      varchar(36)          DEFAULT NULL,
    "LastModifyUser"  varchar(36)          DEFAULT NULL,
    "ProjectID"       varchar(36)          DEFAULT NULL,
    "MappingGroupID"  varchar(36)          DEFAULT NULL,
    "CreateTime"      datetime(6) DEFAULT NULL,
    "UpdateTime"      datetime(6) DEFAULT NULL,
    "ParentId"        varchar(36)          DEFAULT NULL,
    "ChargeAccountId" varchar(1024)     DEFAULT NULL,
    "SortIndex"       bigint NOT NULL DEFAULT 0,
    "Deleted"         boolean   NOT NULL DEFAULT 0,
    "Disabled"        boolean   NOT NULL DEFAULT 0,
    PRIMARY KEY ("AutoID")
);


CREATE TABLE Project_DepartmentAccount(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "DepartmentId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "IsMainDepartment" boolean NOT NULL DEFAULT 0,
  "IsManager" boolean NOT NULL DEFAULT 0,
  "CreateTime" datetime(6) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "UpdateTime" datetime(6) NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "Deleted" boolean NOT NULL DEFAULT 0,
  `DisplayOrder` int NOT NULL DEFAULT 0,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_JobAccount(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "JobId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) NOT NULL,
  "UpdateTime" datetime(6) NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_Finance(
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "Address" varchar(256) DEFAULT NULL,
  "RecipientName" varchar(64) DEFAULT NULL,
  "Postcode" varchar(16) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "Fax" varchar(32) DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "EmailRecipientName" varchar(64) DEFAULT NULL,
  "InvoiceType" int DEFAULT NULL,
  "TaxNumber" varchar(64) DEFAULT NULL,
  "TaxBank" varchar(128) DEFAULT NULL,
  "TaxBankNumber" varchar(64) DEFAULT NULL,
  "TaxRegAddress" varchar(256) DEFAULT NULL,
  "TaxRegContactPhone" varchar(32) DEFAULT NULL,
  "IsGeneralTaxpayer" boolean DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_Job(
  "AutoID" int IDENTITY(1, 1),
  "JobID" varchar(36) NOT NULL,
  "JobName" varchar(128) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_Setting(
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) DEFAULT NULL,
  "SettingName" varchar(64) DEFAULT NULL,
  "SettingValue" varchar(255) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_Source(
  "AutoID" int IDENTITY(1, 1),
  "Source" int DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_WorkSite(
  "AutoID" int IDENTITY(1, 1),
  "WorkSiteID" varchar(36) NOT NULL,
  "WorkSiteName" varchar(128) DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE ProjectAuthorization(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) DEFAULT NULL,
  "AppKey" varchar(100) DEFAULT NULL,
  "SecretKey" varchar(100) DEFAULT NULL,
  "ExpireTime" datetime(6) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Sign" varchar(512) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE RoutingAccount(
  "AutoID" int IDENTITY(1, 1),
  "AccountId" varchar(36) DEFAULT NULL,
  "UserID" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "ServerID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE RoutingProject(
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "ParentID" varchar(36) DEFAULT NULL,
  "ServerID" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "SubDomain" varchar(64) DEFAULT NULL,
  "BaseAuthenticationDomain" varchar(128) DEFAULT NULL,
  "ExpandAuthenticationDomain" varchar(512) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE RoutingProjectExpand(
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "IsEMail" boolean DEFAULT NULL,
  "PaidType" int DEFAULT NULL,
  "Geography" int DEFAULT NULL,
  "Industry" int DEFAULT NULL,
  "Num_User" int DEFAULT NULL,
  "Num_Group" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "Num_Pic" int DEFAULT NULL,
  "Num_Doc" int DEFAULT NULL,
  "Num_QA" int DEFAULT NULL,
  "Num_Task" int DEFAULT NULL,
  "Num_Sms" int DEFAULT NULL,
  "Filesize_Pic" decimal(20,3) DEFAULT NULL,
  "Filesize_Doc" decimal(20,3) DEFAULT NULL,
  "LoginCountByLastWeek" int DEFAULT NULL,
  "PostCountByLastWeek" int DEFAULT NULL,
  "CommentCountByLastWeek" int DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "InvoiceType" int DEFAULT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE RoutingUserExpand(
  "AutoID" int IDENTITY(1, 1),
  "UserID" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Num_ProjectUsers" int DEFAULT NULL,
  "Email" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "IsAdmin" int DEFAULT NULL,
  "UserType" int DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "Mark" int DEFAULT NULL,
  "LastMark" int DEFAULT NULL,
  "Grade" varchar(64) DEFAULT NULL,
  "Avatar" varchar(128) DEFAULT NULL,
  "Gender" int DEFAULT NULL,
  "Birthdate" date DEFAULT NULL,
  "City" varchar(64) DEFAULT NULL,
  "MobilePhone" varchar(32) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "Num_Login" int DEFAULT NULL,
  "Num_View" int DEFAULT NULL,
  "Num_Follower" int DEFAULT NULL,
  "Num_Concern" int DEFAULT NULL,
  "Num_Post" int DEFAULT NULL,
  "Num_Comment" int DEFAULT NULL,
  "LastLoginTime" datetime(6) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "AccountID" varchar(36) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE FixedData(
  "AutoID" int IDENTITY(1, 1),
  "DataID" int DEFAULT NULL,
  "DataName" varchar(128) DEFAULT NULL,
  "ParentDataID" int DEFAULT NULL,
  "DataType" int DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE ImportUserInfo(
  "AutoId" int IDENTITY(1, 1),
  "ProjectID" varchar(36) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Fullname" varchar(100) DEFAULT NULL,
  "Account" varchar(100) DEFAULT NULL,
  "CompanyName" varchar(100) DEFAULT NULL,
  "JobNumber" varchar(100) DEFAULT NULL,
  "ContactPhone" varchar(100) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "WorkSiteId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  "DepartmentIds" varchar(1000) DEFAULT NULL,
  "JobIds" varchar(1000) DEFAULT NULL,
  "OrgRoleIds" varchar(1000) DEFAULT NULL,
  "UseMultiJobs" boolean DEFAULT 0 NOT NULL,
  "DepartmentJobIdMaps" varchar(2000) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE LinkAuthentication(
  "AutoId" int IDENTITY(1, 1),
  "SourceId" varchar(128) DEFAULT NULL,
  "InviteFromType" int DEFAULT NULL,
  "Token" varchar(255) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CreateAccountId" varchar(36) DEFAULT NULL,
  "LinkFromType" int DEFAULT NULL,
  "DeadTime" datetime(6) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE UsersCard(
  "AutoId" int IDENTITY(1, 1),
  "UserId" varchar(36) NOT NULL,
  "AccountId" varchar(36) DEFAULT NULL,
  "ProjectId" varchar(36) DEFAULT NULL,
  "CompanyName" varchar(128) DEFAULT NULL,
  "Fullname" varchar(128) DEFAULT NULL,
  "ContactPhone" varchar(32) DEFAULT NULL,
  "JobNumber" varchar(128) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "DepartmentId" varchar(36) DEFAULT NULL,
  "WorkSiteId" varchar(36) DEFAULT NULL,
  "JobId" varchar(36) DEFAULT NULL,
  "UseMultiJobs" boolean DEFAULT 0 NOT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Role(
  "AutoId" int IDENTITY(1, 1),
  "RoleId" varchar(50) DEFAULT NULL,
  "RoleName" varchar(50) DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "IsDelete" boolean DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "RoleType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE RolePermission(
  "AutoId" int IDENTITY(1, 1),
  "RoleId" varchar(50) DEFAULT NULL,
  "PermissionId" int DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Permission(
  "AutoId" int IDENTITY(1, 1),
  "TypeId" int DEFAULT NULL,
  "TypeName" varchar(100) DEFAULT NULL,
  "PermissionId" int DEFAULT NULL,
  "PermissionName" varchar(100) DEFAULT NULL,
  "IsTypeAdmin" boolean DEFAULT NULL,
  "Description" varchar(200) DEFAULT NULL,
  "ParentId" int DEFAULT NULL,
  "OrderId" int DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "HasChild" boolean DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE UserRole(
  "AutoId" int IDENTITY(1, 1),
  "AccountId" varchar(50) DEFAULT NULL,
  "RoleId" varchar(50) DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "CreateUser" varchar(50) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "LastModifyUser" varchar(50) DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "UserScopeType" int DEFAULT NULL,
  "EntityId" varchar(50) DEFAULT NULL,
  "EntityType" int DEFAULT NULL,
  "OriginId" varchar(50) DEFAULT NULL,
  "OriginName" varchar(50) DEFAULT NULL,
  "OriginType" int DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_UserRule(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "RuleId" varchar(36) NOT NULL,
  "CreateTime" datetime(6) NOT NULL,
  "CreateUser" varchar(36) NOT NULL,
  "UpdateTime" datetime(6) NOT NULL,
  "LastModifyUser" varchar(36) NOT NULL,
  "RuleType" int NOT NULL DEFAULT 10,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_UserRuleItem(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "RuleId" varchar(36) NOT NULL,
  "RuleItemType" int NOT NULL DEFAULT 0,
  "TargetId" varchar(50) NOT NULL,
  "TargetType" int NOT NULL DEFAULT 0,
  "CreateTime" datetime(6) NOT NULL,
  "CreateUser" varchar(36) NOT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_Organize(
  "AutoID" int IDENTITY(1, 1),
  "OrganizeID" varchar(36) NOT NULL,
  "OrganizeGroupID" varchar(36) DEFAULT NULL,
  "OrganizeName" varchar(128) DEFAULT NULL,
  "ProjectID" varchar(36) NOT NULL,
  "Remark" text,
  "SortIndex" int NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime DEFAULT NULL,
  "UpdateTime" datetime DEFAULT NULL,
  "Disabled" boolean NOT NULL DEFAULT 0,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_OrganizeAccount(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "OrganizeId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "CreateUser" varchar(36) DEFAULT NULL,
  "CreateTime" datetime NOT NULL,
  "UpdateTime" datetime NOT NULL,
  "LastModifyUser" varchar(36) DEFAULT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_OrgRoleChargeDepartment(
  "AutoId" int IDENTITY(1, 1),
  "ProjectId" varchar(36) NOT NULL,
  "OrgRoleId" varchar(36) NOT NULL,
  "AccountId" varchar(36) NOT NULL,
  "DepartmentId" varchar(36) NOT NULL,
  "IsIncludeSub" boolean NOT NULL DEFAULT 1,
  "CreateUser" varchar(36) NOT NULL,
  "CreateTime" datetime NOT NULL,
  "UpdateTime" datetime NOT NULL,
  "LastModifyUser" varchar(36) NOT NULL,
  PRIMARY KEY ("AutoId")
);

CREATE TABLE Project_OrgRoleGroup(
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) NOT NULL,
  "OrganizeGroupID" varchar(36) NOT NULL,
  "OrganizeGroupName" varchar(128),
  "SortIndex" int DEFAULT 0 NOT NULL,
  "CreateUser" varchar(36) NOT NULL,
  "LastModifyUser" varchar(36) NOT NULL,
  "CreateTime" datetime NOT NULL,
  "UpdateTime" datetime NOT NULL,
  "Disabled" boolean NOT NULL DEFAULT 0,
  PRIMARY KEY ("AutoId")
);

CREATE INDEX idx_account_aid ON Account("AccountId");
CREATE INDEX idx_amedal_mid ON Account_Medal("MedalId");
CREATE INDEX idx_amedal_gid ON Account_MedalGrantLog("GrantId");
CREATE INDEX idx_aexpand_aid ON AccountExpand("AccountId");
CREATE INDEX idx_ainfo_aid ON AccountInfo("AccountId");
CREATE INDEX idx_astatistic_aid ON AccountStatistic("AccountID");
CREATE INDEX idx_project_pid ON Project("ProjectID");
CREATE INDEX idx_pdept_pid_paid ON Project_Department("ProjectID","ParentId");
CREATE INDEX idx_pdept_did_pid ON Project_Department("DepartmentID","ProjectID");
CREATE INDEX idx_pda_pid_did_aid ON Project_DepartmentAccount("ProjectId","DepartmentId","AccountId");
CREATE INDEX idx_pda_pid_aid ON Project_DepartmentAccount("ProjectId","AccountId");
CREATE INDEX idx_pda_pid_did_ord ON Project_DepartmentAccount("ProjectId","DepartmentId","DisplayOrder");
CREATE INDEX idx_pja_pid_jid_aid ON Project_JobAccount("ProjectId","JobId","AccountId");
CREATE INDEX idx_pja_pid_aid ON Project_JobAccount("ProjectId","AccountId");
CREATE INDEX idx_pf_pid ON Project_Finance("ProjectID");
CREATE INDEX idx_pj_pid_jid ON Project_Job("ProjectID","JobID");
CREATE INDEX idx_pj_jid ON Project_Job("JobID");
CREATE INDEX idx_pw_pid_wid ON Project_WorkSite("ProjectID","WorkSiteID");
CREATE INDEX idx_pw_wid ON Project_WorkSite("WorkSiteID");
CREATE UNIQUE INDEX uidx_ra_pid_aid ON RoutingAccount("ProjectID","AccountId");
CREATE INDEX idx_ra_aid_pid ON RoutingAccount("AccountId","ProjectID");
CREATE INDEX idx_rp_pid ON RoutingProject("ProjectID");
CREATE INDEX idx_rpe_pid ON RoutingProjectExpand("ProjectID");
CREATE UNIQUE INDEX uidx_ucard_pid_aid ON UsersCard("ProjectId","AccountId");
CREATE INDEX idx_ucard_aid_pid ON UsersCard("AccountId","ProjectId");
CREATE INDEX idx_role_pid_rid ON Role("RoleId");
CREATE INDEX idx_role_rid_eid_etype ON Role("RoleId","EntityId","EntityType");
CREATE INDEX idx_rp_pid_pmsid ON RolePermission("PermissionId");
CREATE INDEX idx_rp_pid_rid ON RolePermission("RoleId");
CREATE INDEX idx_rp_pid_eid_etype ON RolePermission("PermissionId","EntityId","EntityType");
CREATE INDEX idx_rp_rid_eid_etype ON RolePermission("RoleId","EntityId","EntityType");
CREATE INDEX idx_perm_pid_etype ON Permission("PermissionId","EntityType");
CREATE INDEX idx_ur_aid_pid ON UserRole("AccountId");
CREATE INDEX idx_ur_pid_rid ON UserRole("RoleId");
CREATE INDEX idx_ur_etype_eid_aid ON UserRole("EntityType","EntityId","AccountId");
CREATE INDEX idx_ur_etype_eid_rid ON UserRole("EntityType","EntityId","RoleId");
CREATE INDEX idx_pur_pid ON Project_UserRule("ProjectId");
CREATE INDEX idx_pur_rid ON Project_UserRule("RuleId");
CREATE INDEX idx_puri_pid_rid ON Project_UserRuleItem("ProjectId","RuleId");
CREATE INDEX idx_po_pid_oid ON Project_Organize("ProjectID","OrganizeID");
CREATE INDEX idx_pora_pid_oid_aid ON Project_OrganizeAccount("ProjectId","OrganizeId","AccountId");
CREATE INDEX idx_porcd_pid_orid_aid ON Project_OrgRoleChargeDepartment("ProjectId","OrgRoleId","AccountId");
CREATE INDEX idx_porg_pid ON Project_OrgRoleGroup("ProjectId");