USE MDLog;

CREATE TABLE Account_ActionLog (
  "AutoID" int IDENTITY(1, 1),
  "AccountID" varchar(36) DEFAULT NULL,
  "Title" varchar(255) DEFAULT NULL,
  "Description" varchar(512) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "IP" varchar(32) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Account_CostLog (
  "AutoID" int IDENTITY(1, 1),
  "AccountID" varchar(36) DEFAULT NULL,
  "Title" varchar(255) DEFAULT NULL,
  "CostMark" int DEFAULT NULL,
  "LeftMark" int DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_CostLog (
  "AutoID" int IDENTITY(1, 1),
  "ProjectID" varchar(36) DEFAULT NULL,
  "Type" int DEFAULT NULL,
  "Title" varchar(255) DEFAULT NULL,
  "CostMark" decimal(18,4) DEFAULT NULL,
  "LeftMark" decimal(18,4) DEFAULT NULL,
  "CreateAccount" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_CostOperateLog (
  "AutoID" int IDENTITY(1, 1),
  "RecordID" varchar(36) DEFAULT NULL,
  "OrderID" varchar(36) DEFAULT NULL,
  "Price" decimal(18,4) DEFAULT NULL,
  "OperateType" int DEFAULT NULL,
  "Remark" text,
  "CreateAccount" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);

CREATE TABLE Project_TransactionRecord (
  "AutoID" int IDENTITY(1, 1),
  "RecordID" varchar(36) DEFAULT NULL,
  "OrderID" varchar(36) DEFAULT NULL,
  "AppID" varchar(36) DEFAULT NULL,
  "RecordType" int DEFAULT NULL,
  "Status" int DEFAULT NULL,
  "Price" decimal(18,4) DEFAULT NULL,
  "Remark" text,
  "CreateAccount" varchar(36) DEFAULT NULL,
  "PayAccount" varchar(36) DEFAULT NULL,
  "ProjectID" varchar(36) DEFAULT NULL,
  "CreateTime" datetime(6) DEFAULT NULL,
  "CustomOverdueTime" datetime(6) DEFAULT NULL,
  "UpdateTime" datetime(6) DEFAULT NULL,
  "RecordTypeTitle" varchar(128) DEFAULT NULL,
  "ExtendId" varchar(128) DEFAULT NULL,
  PRIMARY KEY ("AutoID")
);
