CREATE DATABASE IF NOT EXISTS MDCalendar DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci;
USE MDCalendar;

CREATE TABLE `Calendar` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `CalendarID` varchar(64) NOT NULL,
  `CalendarName` varchar(512) DEFAULT NULL,
  `StartTime` datetime(6) DEFAULT NULL,
  `EndTime` datetime(6) DEFAULT NULL,
  `IsAllDay` boolean DEFAULT NULL,
  `Address` varchar(512) DEFAULT NULL,
  `Description` varchar(1024) DEFAULT NULL,
  `Types` tinyint(4) DEFAULT NULL,
  `GroupID` varchar(512) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `Sequence` int(11) DEFAULT 0,
  `IsRecur` boolean DEFAULT 0,
  `Frequency` tinyint(4) DEFAULT 0,
  `Interval` int(11) DEFAULT 1,
  `RecurCount` int(11) DEFAULT 0,
  `UntilDate` datetime(6) DEFAULT NULL,
  `WeekDay` int(11) DEFAULT NULL,
  `EventStart` datetime(6) DEFAULT NULL,
  `EventEnd` datetime(6) DEFAULT NULL,
  `CreateUser` varchar(64) DEFAULT NULL,
  `AppID` varchar(64) DEFAULT NULL,
  `IsDelete` boolean DEFAULT 0,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `Locked` boolean DEFAULT NULL,
  `CreateAccountID` varchar(64) DEFAULT NULL,
  `IsPrivate` boolean NOT NULL DEFAULT 0,
  PRIMARY KEY (`AutoID`) USING BTREE,
  UNIQUE KEY `uk_calendarid` (`CalendarID`) USING BTREE,
  KEY `idx_caid` (`CreateAccountID`),
  KEY `idx_eventend` (`EventEnd`),
  KEY `idx_starttime_calendarid` (`StartTime`,`CalendarID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Calendar_Category` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `CatID` varchar(64) NOT NULL,
  `UserID` varchar(64) DEFAULT NULL,
  `Color` int(11) DEFAULT NULL,
  `CatName` varchar(400) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`AutoID`) USING BTREE,
  UNIQUE KEY `uk_catid` (`CatID`) USING BTREE,
  KEY `idx_aid_catid` (`AccountID`,`CatID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `Calendar_Member` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `CalendarID` varchar(64) NOT NULL,
  `UserID` varchar(64) DEFAULT NULL,
  `Email` varchar(128) DEFAULT NULL,
  `MobilePhone` varchar(32) DEFAULT NULL,
  `CatID` varchar(128) DEFAULT NULL,
  `GroupID` varchar(64) DEFAULT NULL,
  `Types` tinyint(4) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `ReMark` varchar(1024) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `RemindTime` int(11) DEFAULT NULL,
  `RemindType` tinyint(4) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `VoiceRemind` boolean DEFAULT 0,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_calendarid` (`CalendarID`),
  KEY `idx_aid` (`AccountID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ChildCalendarRecurTime` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `CalendarID` varchar(64) NOT NULL,
  `RecurTime` datetime(6) NOT NULL,
  `StartTime` datetime(6) NOT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `CalendarName` varchar(512) DEFAULT NULL,
  `EndTime` datetime(6) DEFAULT NULL,
  `IsAllDay` boolean DEFAULT NULL,
  `Address` varchar(512) DEFAULT NULL,
  `Description` varchar(1024) DEFAULT NULL,
  `Types` tinyint(4) DEFAULT NULL,
  `GroupID` varchar(512) DEFAULT NULL,
  `Sequence` int(11) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `CreateUser` varchar(64) DEFAULT NULL,
  `Locked` boolean DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `CreateAccountID` varchar(64) DEFAULT NULL,
  `IsPrivate` boolean NOT NULL DEFAULT 0,
  PRIMARY KEY (`AutoID`) USING BTREE,
  UNIQUE KEY `uk_calendarid_recur` (`CalendarID`,`RecurTime`) USING BTREE,
  KEY `idx_starttime_endtime` (`StartTime`,`EndTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ChildCalendarRecurTimeMember` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `CalendarID` varchar(64) NOT NULL,
  `UserID` varchar(64) DEFAULT NULL,
  `RecurTime` datetime(6) NOT NULL,
  `Email` varchar(128) DEFAULT NULL,
  `MobilePhone` varchar(32) DEFAULT NULL,
  `GroupID` varchar(64) DEFAULT NULL,
  `CatID` varchar(64) DEFAULT NULL,
  `Types` tinyint(4) DEFAULT NULL,
  `Status` tinyint(4) DEFAULT NULL,
  `ReMark` varchar(1024) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `RemindTime` int(11) DEFAULT NULL,
  `RemindType` tinyint(4) DEFAULT NULL,
  `UpdateTime` datetime(6) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `VoiceRemind` boolean DEFAULT 0,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_calendarid_recurtime_aid` (`CalendarID`,`RecurTime`,`AccountID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ThirdUser` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `ThirdID` varchar(50) NOT NULL,
  `CalendarID` varchar(64) NOT NULL,
  `RecurTime` datetime(6) DEFAULT NULL,
  `CreateTime` datetime(6) NOT NULL,
  `EditTime` datetime(6) NOT NULL,
  `NickName` varchar(50) DEFAULT NULL,
  `Face` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_calendarid` (`CalendarID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `User_CalCategory_Order` (
  `AutoID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` varchar(64) DEFAULT NULL,
  `CatID` varchar(64) DEFAULT NULL,
  `DisplayOrder` int(11) DEFAULT NULL,
  `ProjectID` varchar(64) DEFAULT NULL,
  `CreateTime` datetime(6) DEFAULT NULL,
  `AccountID` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`AutoID`) USING BTREE,
  KEY `idx_aid_catid` (`AccountID`,`CatID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;